/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.hdcp;

import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.StdConnectionManager;
import com.quantumdata.std.SystemConsole;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class HDCPGUI
extends QDPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private QDCheckBox[] m_checkBoxes;
    private QDCheckBox[] m_testCheckboxes;
    private QDPanel innerPanel2;
    private QDPanel sourcePanel;
    private QDPanel sinkPanel;
    private QDPanel repeaterPanel;
    private QDPanel sourceTestPanel;
    private QDPanel sinkTestPanel;
    private QDPanel repeaterTestPanel;
    private QDPanel sourcePCPPanel;
    private QDPanel sinkPCPPanel;
    private QDPanel repeaterPCPPanel;
    private static final Font m_checkBoxFont = new Font("SansSerif", 1, 12);
    private int[] deviceOffsets = new int[]{0, 15, 19, 45};
    private String[] m_testNums = new String[]{"1A-01", "1A-02", "1A-03", "1A-04", "1A-05", "1A-06", "1A-07", "1A-08", "1A-09", "1B-01", "1B-02", "1B-03", "1B-04", "1B-05", "1B-06", "2C-01", "2C-02", "2C-03", "2C-04", "3A-01", "3A-02", "3A-03", "3A-04", "3A-05", "3B-01", "3B-02", "3B-03", "3B-04", "3B-05", "3C-I-01", "3C-I-02", "3C-I-03", "3C-I-04", "3C-I-05", "3C-I-06", "3C-I-07", "3C-II-01", "3C-II-02", "3C-II-03", "3C-II-04", "3C-II-05", "3C-II-06", "3C-II-07", "3C-II-08", "3C-II-09"};
    private String[] m_testDescriptions = new String[]{"Regular procedure: With HDMI-capable Receiver", "Regular procedure: HPD after writing Aksv", "Regular procedure: HPD after starting third part of authentication", "Irregular procedure: (First part of authentication) HDCP port access", "Irregular procedure: (First part of authentication) Verify Bksv", "Irregular procedure: (First part of authentication) Verify R0'", "Irregular procedure: (Third part of authentication) Verify Ri'", "Irregular procedure: SRM", "Regular procedure: With DVI Receiver", "Regular procedure: With Repeater", "Regular procedure: HPD after reading R0'", "Irregular procedure: (Second part of authentication) Timeout of KSV list READY", "Irregular procedure: (Second part of authentication) Verify V'", "Irregular procedure: (Second part of authentication) MAX_DEVS_EXCEEDED", "Irregular procedure: (Second part of authentication) MAX_CASCADE_EXCEEDED", "Regular procedure: With HDMI-capable Transmitter", "Irregular procedure: (First part of authentication) New Authentication", "Irregular procedure: (Third part of authentication) New Authentication", "Regular procedure: With DVI Transmitter", "Regular procedure: With HDMI-capable Receiver", "Irregular procedure: (First part of authentication) HDCP port access", "Irregular procedure: (First part of authentication) Verify Bksv", "Irregular procedure: (First part of authentication) Verify R0'", "Regular procedure: With DVI Receiver", "Regular procedure: With Repeater", "Irregular procedure: (Second part of authentication) Timeout of KSV list READY", "Irregular procedure: (Second part of authentication) Verify V'", "Irregular procedure: (Second part of authentication) MAX_DEVS_EXCEEDED", "Irregular procedure: (Second part of authentication) MAX_CASCADE_EXCEEDED", "Regular procedure: Transmitter -- DUT - Receiver", "Regular procedure: HPD pulse output caused by user operation", "Irregular procedure: (First part of authentication) New Authentication", "Irregular procedure: (Second part of authentication) New Authentication", "Irregular procedure: (Third part of authentication) New Authentication", "Irregular procedure: (Second part of authentication) Verify Bksv", "Irregular procedure: (Second part of authentication) Verify R0'", "Regular procedure: Transmitter -- DUT - Repeater+Receiver", "Regular procedure: HPD after writing Aksv", "Regular procedure: HPD after reading R0'", "Regular procedure: HPD after starting third part of authentication", "Irregular procedure: (Second part of authentication) Verify V'", "Irregular procedure: (Second part of authentication) DEVICE_COUNT", "Irregular procedure: (Second part of authentication) DEPTH", "Irregular procedure: (Second part of authentication) MAX_DEVS_EXCEEDED", "Irregular procedure: (Second part of authentication) MAX_CASCADE_EXCEEDED"};
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private JButton[] button;
    private JTextField[] m_textFields;
    private JComboBox[] m_comboBoxes;
    private JTabbedPane m_tabs;
    String tempStr = "";
    RemoteInstrument m_instrument;
    String fileStr = "Unknown";

    public HDCPGUI() {
        this.m_checkBoxes = new QDCheckBox[13];
        this.m_testCheckboxes = new QDCheckBox[this.m_testNums.length];
        for (int i = 0; i < this.m_testNums.length; ++i) {
            this.m_testCheckboxes[i] = new QDCheckBox(this.m_testNums[i] + ": " + this.m_testDescriptions[i]);
            this.m_testCheckboxes[i].setFont(m_checkBoxFont);
            this.m_testCheckboxes[i].setSelected(true);
        }
        this.m_textFields = new JTextField[3];
        this.m_comboBoxes = new JComboBox[2];
        this.button = new JButton[2];
        this.m_tabs = new JTabbedPane();
        this.add((Component)this.m_tabs, "Center");
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 5, 2, 5);
        this.sourcePCPPanel = new QDPanel(this.gbl);
        this.sinkPCPPanel = new QDPanel(this.gbl);
        this.repeaterPCPPanel = new QDPanel(this.gbl);
        TitledBorder titledBorder = new TitledBorder("PCP Parameters");
        titledBorder.setTitleColor(Color.WHITE);
        this.sourcePCPPanel.setBorder(titledBorder);
        this.sinkPCPPanel.setBorder(titledBorder);
        this.repeaterPCPPanel.setBorder(titledBorder);
        Dimension dimension = new Dimension(350, 240);
        this.repeaterPCPPanel.setMinimumSize(dimension);
        this.repeaterPCPPanel.setPreferredSize(dimension);
        dimension = new Dimension(350, 150);
        this.sourcePCPPanel.setMinimumSize(dimension);
        this.sourcePCPPanel.setPreferredSize(dimension);
        this.sinkPCPPanel.setMinimumSize(dimension);
        this.sinkPCPPanel.setPreferredSize(dimension);
        titledBorder = new TitledBorder("Test List");
        titledBorder.setTitleColor(Color.WHITE);
        this.sourcePanel = new QDPanel(this.gbl);
        this.sinkPanel = new QDPanel(this.gbl);
        this.repeaterPanel = new QDPanel(this.gbl);
        Dimension dimension2 = new Dimension(650, 500);
        this.gbc.anchor = 17;
        this.gbc.gridwidth = 4;
        this.gbc.gridy = 0;
        this.gbc.gridx = 8;
        this.sourcePanel.add((Component)this.sourcePCPPanel, this.gbc);
        this.gbc.gridy = 0;
        this.gbc.gridx = 8;
        this.sinkPanel.add((Component)this.sinkPCPPanel, this.gbc);
        this.gbc.gridy = 0;
        this.gbc.gridx = 8;
        this.repeaterPanel.add((Component)this.repeaterPCPPanel, this.gbc);
        this.gbc.gridwidth = 1;
        JScrollPane jScrollPane = new JScrollPane(this.sourcePanel, 20, 30);
        jScrollPane.setMaximumSize(dimension2);
        jScrollPane.setPreferredSize(dimension2);
        this.m_tabs.addTab("Source", jScrollPane);
        jScrollPane = new JScrollPane(this.sinkPanel, 20, 30);
        jScrollPane.setMaximumSize(dimension2);
        jScrollPane.setPreferredSize(dimension2);
        this.m_tabs.addTab("Sink", jScrollPane);
        jScrollPane = new JScrollPane(this.repeaterPanel, 20, 30);
        jScrollPane.setMaximumSize(dimension2);
        jScrollPane.setPreferredSize(dimension2);
        this.m_tabs.addTab("Repeater", jScrollPane);
    }

    public void setInstrument(StdConnectionManager stdConnectionManager, String string) {
        if (string.equals("")) {
            Object object = JOptionPane.showInputDialog(this, "Enter an IP Address:", "Connect to?", 3, null, null, string);
            if (object == null || !(object instanceof String)) {
                return;
            }
            string = (String)object;
        }
        SocketConnection socketConnection = new SocketConnection(string);
        this.m_instrument = new RemoteInstrument(socketConnection, new SystemConsole());
        try {
            this.m_instrument.connect();
        }
        catch (InstrumentException instrumentException) {
            this.ShowErrorMessage("Unable to connect to: " + string);
            System.exit(0);
        }
        stdConnectionManager.addInstrument(this.m_instrument);
        this.init();
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
        this.init();
    }

    private void init() {
        InstrumentResponse instrumentResponse;
        int n;
        this.m_checkBoxes[0] = new QDCheckBox("Repeater_1.1_Features");
        this.m_checkBoxes[0].putClientProperty("Command", "RPFT");
        this.m_checkBoxes[1] = new QDCheckBox("Repeater_Out_OnlyRep");
        this.m_checkBoxes[1].putClientProperty("Command", "ROOR");
        this.m_checkBoxes[2] = new QDCheckBox("Repeater_Audio_Support");
        this.m_checkBoxes[2].putClientProperty("Command", "RPAS");
        this.m_checkBoxes[3] = new QDCheckBox("Repeater_HPD_Pulse");
        this.m_checkBoxes[3].putClientProperty("Command", "RHPD");
        this.m_checkBoxes[4] = new QDCheckBox("Sink_1.1_Features");
        this.m_checkBoxes[4].putClientProperty("Command", "SRFT");
        this.m_checkBoxes[5] = new QDCheckBox("Sink_Audio_Support");
        this.m_checkBoxes[5].putClientProperty("Command", "SNAS");
        this.m_checkBoxes[6] = new QDCheckBox("Source_Out_OnlyRep");
        this.m_checkBoxes[6].putClientProperty("Command", "SOOR");
        this.m_checkBoxes[7] = new QDCheckBox("Combined Reads");
        this.m_checkBoxes[7].putClientProperty("Command", "CRIP");
        this.m_checkBoxes[8] = new QDCheckBox("Write Ainfo");
        this.m_checkBoxes[8].putClientProperty("Command", "WAIN");
        this.m_checkBoxes[9] = new QDCheckBox("Device_Count_Zero");
        this.m_checkBoxes[9].putClientProperty("Command", "SDCZ");
        this.m_checkBoxes[10] = new QDCheckBox("Device_Count_Zero");
        this.m_checkBoxes[10].putClientProperty("Command", "SDCZ");
        this.m_checkBoxes[11] = new QDCheckBox("Combined Reads");
        this.m_checkBoxes[11].putClientProperty("Command", "CRIP");
        this.m_checkBoxes[12] = new QDCheckBox("Write Ainfo");
        this.m_checkBoxes[12].putClientProperty("Command", "WAIN");
        block6: for (n = 0; n < this.m_checkBoxes.length; ++n) {
            this.m_checkBoxes[n].setFont(m_checkBoxFont);
            this.m_checkBoxes[n].addActionListener(this);
            instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.m_checkBoxes[n].getClientProperty("Command") + "?");
            if (instrumentResponse.getResponse().equals("1")) {
                this.m_checkBoxes[n].setSelected(true);
            }
            switch (n) {
                case 0: {
                    this.m_checkBoxes[12].setEnabled(this.m_checkBoxes[0].isSelected());
                    continue block6;
                }
                case 1: {
                    this.m_checkBoxes[10].setEnabled(this.m_checkBoxes[1].isSelected());
                    continue block6;
                }
                case 4: {
                    this.m_checkBoxes[8].setEnabled(this.m_checkBoxes[4].isSelected());
                    continue block6;
                }
                case 6: {
                    this.m_checkBoxes[9].setEnabled(this.m_checkBoxes[6].isSelected());
                }
            }
        }
        this.m_textFields[0] = new JTextField("0");
        this.m_textFields[0].putClientProperty("Command", "SKSV");
        this.m_textFields[1] = new JTextField("0");
        this.m_textFields[1].putClientProperty("Command", "SRAC");
        this.m_textFields[2] = new JTextField("0");
        this.m_textFields[2].putClientProperty("Command", "RKSV");
        for (n = 0; n < this.m_textFields.length; ++n) {
            instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.m_textFields[n].getClientProperty("Command") + "?");
            this.m_textFields[n].setText(instrumentResponse.getResponse());
        }
        this.m_comboBoxes[0] = new JComboBox();
        Dimension dimension = new Dimension(150, 40);
        this.m_comboBoxes[0].putClientProperty("Command", "DUTT");
        this.m_comboBoxes[0].addItem(new String("2C tests"));
        this.m_comboBoxes[0].addItem(new String("1AB tests"));
        this.m_comboBoxes[0].addItem(new String("3ABC tests"));
        this.m_comboBoxes[0].addItem(new String("3AB tests"));
        this.m_comboBoxes[0].addItem(new String("3C tests"));
        this.m_comboBoxes[1] = new JComboBox();
        this.m_comboBoxes[1].putClientProperty("Command", "OESS");
        this.m_comboBoxes[1].addItem(new String("Pass-through"));
        this.m_comboBoxes[1].addItem(new String("Leading"));
        this.m_comboBoxes[1].addItem(new String("Trailing"));
        this.m_comboBoxes[1].addItem(new String("Center"));
        for (int i = 0; i < this.m_comboBoxes.length; ++i) {
            this.m_comboBoxes[i].setBackground(Color.white);
            instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.m_comboBoxes[i].getClientProperty("Command") + "?");
            this.m_comboBoxes[i].setSelectedIndex(Integer.parseInt(instrumentResponse.getResponse()));
        }
        this.gbc.anchor = 17;
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.sourcePCPPanel.add((Component)this.m_checkBoxes[6], this.gbc);
        this.sinkPCPPanel.add((Component)this.m_checkBoxes[4], this.gbc);
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[1], this.gbc);
        this.gbc.gridx = 2;
        this.sourcePCPPanel.add((Component)this.m_checkBoxes[9], this.gbc);
        this.sinkPCPPanel.add((Component)this.m_checkBoxes[8], this.gbc);
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[10], this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.sinkPCPPanel.add((Component)this.m_checkBoxes[5], this.gbc);
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[0], this.gbc);
        this.gbc.gridx = 2;
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[12], this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.sinkPCPPanel.add((Component)this.m_checkBoxes[7], this.gbc);
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[2], this.gbc);
        this.gbc.gridy = 4;
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[3], this.gbc);
        JLabel[] jLabelArray = new JLabel[]{new JLabel("Source_Max_KSV"), new JLabel("<HTML>Source_Authentication<br>Count</HTML>"), new JLabel("Repeater_Max_KSV"), new JLabel("OESS: ")};
        for (int i = 0; i < jLabelArray.length; ++i) {
            jLabelArray[i].setForeground(Color.WHITE);
        }
        this.gbc.gridwidth = 1;
        this.gbc.gridy = 3;
        this.gbc.gridx = 0;
        this.sourcePCPPanel.add((Component)jLabelArray[0], this.gbc);
        this.gbc.gridx = 1;
        this.sourcePCPPanel.add((Component)this.m_textFields[0], this.gbc);
        this.gbc.gridy = 5;
        this.gbc.gridx = 0;
        this.repeaterPCPPanel.add((Component)this.m_checkBoxes[11], this.gbc);
        this.sourcePCPPanel.add((Component)jLabelArray[1], this.gbc);
        this.sinkPCPPanel.add((Component)jLabelArray[3], this.gbc);
        this.gbc.gridx = 1;
        this.sourcePCPPanel.add((Component)this.m_textFields[1], this.gbc);
        this.sinkPCPPanel.add((Component)this.m_comboBoxes[1], this.gbc);
        this.gbc.gridy = 6;
        this.gbc.gridx = 0;
        this.repeaterPCPPanel.add((Component)jLabelArray[2], this.gbc);
        this.gbc.gridx = 1;
        this.repeaterPCPPanel.add((Component)this.m_textFields[2], this.gbc);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        dimension = new Dimension(50, 30);
        for (int i = 0; i < 3; ++i) {
            gridBagConstraints.gridx = i % 2 * 2;
            gridBagConstraints.gridy = 5 + i / 2;
            ++gridBagConstraints.gridx;
            this.m_textFields[i].setMinimumSize(dimension);
            this.m_textFields[i].setPreferredSize(dimension);
        }
        this.innerPanel2 = new QDPanel();
        this.button[0] = new QDButton("Use PCP");
        this.button[0].addActionListener(this);
        this.innerPanel2.add(this.button[0]);
        this.button[1] = new QDButton("Run Tests");
        this.button[1].addActionListener(this);
        this.innerPanel2.add(this.button[1]);
        this.button[1].setEnabled(false);
        this.button[1].setToolTipText("Not yet implemented.");
        this.button[1].setVisible(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.innerPanel2, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_instrument.isConnected()) {
            return;
        }
        if (actionEvent.getSource() == this.button[0]) {
            QDPanel qDPanel;
            switch (this.m_tabs.getSelectedIndex()) {
                default: {
                    qDPanel = this.sourcePCPPanel;
                    int n = 1;
                    break;
                }
                case 1: {
                    qDPanel = this.sinkPCPPanel;
                    int n = 0;
                    break;
                }
                case 2: {
                    qDPanel = this.repeaterPCPPanel;
                    int n = 3;
                }
            }
            for (int i = 0; i < qDPanel.getComponentCount(); ++i) {
                if (qDPanel.getComponent(i) instanceof QDCheckBox) {
                    this.tempStr = ((QDCheckBox)qDPanel.getComponent(i)).getClientProperty("Command") + " ";
                    this.tempStr = ((QDCheckBox)qDPanel.getComponent(i)).isSelected() ? this.tempStr + "1" : this.tempStr + "0";
                } else if (qDPanel.getComponent(i) instanceof JComboBox) {
                    this.tempStr = ((JComboBox)qDPanel.getComponent(i)).getClientProperty("Command") + " " + ((JComboBox)qDPanel.getComponent(i)).getSelectedIndex();
                } else if (qDPanel.getComponent(i) instanceof JTextField) {
                    this.tempStr = ((JTextField)qDPanel.getComponent(i)).getClientProperty("Command") + " " + ((JTextField)qDPanel.getComponent(i)).getText();
                }
                if (this.tempStr.length() != 0) {
                    try {
                        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.tempStr);
                        if (instrumentResponse.isError()) {
                            this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                        }
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
                    }
                }
                this.tempStr = "";
            }
        } else if (actionEvent.getSource() == this.button[1]) {
            InstrumentResponse instrumentResponse;
            int n;
            int n2 = this.m_tabs.getSelectedIndex();
            switch (n2) {
                default: {
                    n = 1;
                    JOptionPane.showMessageDialog(this, "Connect 'HDMI Out' of EST to the 882's HDMI In #1, and 'HDMI In' to the DUT's output.", "Information", 1);
                    break;
                }
                case 1: {
                    n = 0;
                    JOptionPane.showMessageDialog(this, "Connect 'HDMI Out' of EST to the DUT's input, and 'HDMI In' to the 882's HDMI Out #1.", "Information", 1);
                    break;
                }
                case 2: {
                    n = 3;
                    JOptionPane.showMessageDialog(this, "Connect 'HDMI Out' of EST to the 882's HDMI In #1, and 'HDMI In' to the DUT's output.", "Information", 1);
                }
            }
            try {
                instrumentResponse = this.m_instrument.sendCmd("CPTX:DUTT " + n);
                if (instrumentResponse.isError()) {
                    instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                    this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                }
            }
            catch (Exception exception) {
                this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
            }
            for (int i = this.deviceOffsets[n2]; i < this.deviceOffsets[n2 + 1]; ++i) {
                if (n == 3 && i > 28) {
                    n = 4;
                    try {
                        instrumentResponse = this.m_instrument.sendCmd("CPTX:DUTT " + n);
                        if (instrumentResponse.isError()) {
                            instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                            this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                        }
                    }
                    catch (Exception exception) {
                        this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
                    }
                    JOptionPane.showMessageDialog(this, "Connect 'HDMI Out' of EST to the DUT's input, and 'HDMI In' to the 882's HDMI Out #1.", "Information", 1);
                }
                if (!this.m_testCheckboxes[i].isSelected()) continue;
                try {
                    boolean bl = true;
                    String string = "1";
                    while (string.equals("1")) {
                        if (!bl) {
                            Thread.sleep(1000L);
                        }
                        bl = false;
                        instrumentResponse = this.m_instrument.sendCmd("CPTX:CPTU?");
                        if (instrumentResponse.isError()) {
                            instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                            this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                        }
                        string = instrumentResponse.getResponse();
                    }
                    instrumentResponse = this.m_instrument.sendCmd("CPTX:CPTR " + (i + 1));
                    if (instrumentResponse.isError()) {
                        instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                        this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                    }
                    if ((instrumentResponse = this.m_instrument.sendCmd("CPTX:CPTU")).isError()) {
                        instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                        this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                    }
                    string = "1";
                    Thread.sleep(3000L);
                    while (string.equals("1")) {
                        Thread.sleep(1000L);
                        instrumentResponse = this.m_instrument.sendCmd("CPTX:CPTU?");
                        if (instrumentResponse.isError()) {
                            instrumentResponse = this.m_instrument.sendCmd("ERRY?");
                            this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                        }
                        string = instrumentResponse.getResponse();
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
                }
            }
        } else if (actionEvent.getSource() == this.m_checkBoxes[0]) {
            this.m_checkBoxes[12].setEnabled(this.m_checkBoxes[0].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[1]) {
            this.m_checkBoxes[10].setEnabled(this.m_checkBoxes[1].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[4]) {
            this.m_checkBoxes[8].setEnabled(this.m_checkBoxes[4].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[6]) {
            this.m_checkBoxes[9].setEnabled(this.m_checkBoxes[6].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[7]) {
            this.m_checkBoxes[11].setSelected(this.m_checkBoxes[7].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[8]) {
            this.m_checkBoxes[12].setSelected(this.m_checkBoxes[8].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[9]) {
            this.m_checkBoxes[10].setSelected(this.m_checkBoxes[9].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[10]) {
            this.m_checkBoxes[9].setSelected(this.m_checkBoxes[10].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[11]) {
            this.m_checkBoxes[7].setSelected(this.m_checkBoxes[11].isSelected());
        } else if (actionEvent.getSource() == this.m_checkBoxes[12]) {
            this.m_checkBoxes[8].setSelected(this.m_checkBoxes[12].isSelected());
        }
    }

    public void printGeneratorError(int n) {
        String string = "Unknown error " + n + " occurred.  May not affect testing.";
        if (n == 1) {
            string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
        }
        if (n == 4) {
            string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
        }
        if (n == 6) {
            string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 6)";
        }
        if (n == 99) {
            string = "Internal error!  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 99)";
        }
        if (n == 10031) {
            string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
        }
        if (n == 20000) {
            string = "Error!  Test equipment not connected.  Please restart and connect.";
        }
        if (n == 20001) {
            string = "Error!  No value was entered by the tester when one was required!";
        }
        if (n == 20002) {
            string = "Error!  No selection was made by the tester when one was required!";
        }
        if (n == 20003) {
            string = "Error!  Could not perform task (Exception occurred).";
        }
        if (n == 20005) {
            string = "Error!  Text input was not a number, when a number was expected.";
        }
        this.ShowErrorMessage(string);
    }

    private void ShowErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Error!", 0);
    }

    public void disconnect() {
        this.m_instrument.disconnect();
    }
}

